<?php

namespace App\Repositories\V1\Roles;

use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;
use Spatie\Permission\Models\Role;
use Illuminate\Pagination\LengthAwarePaginator;


interface PermissionRepositoryInterface
{
    public function index(): Collection;

    public function getRoles(Utility $utility): Collection;
    
    public function getRolesPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator;

    public function create(array $data): Role;

    public function update(int $id, array $data): bool;

    public function getById(int $id): Role;

    public function getPermissionsByIds(array $ids): Collection;

    public function getRolesByIds(array $ids): Collection;
}
