<?php

namespace App\Repositories\V1\Projects;

use App\Models\ProjectLike;

interface ProjectLikeRepositoryInterface
{
    public function findByUserAndProject(int $userId, int $projectId): bool;

    public function create(array $data): ProjectLike;

    public function findById(int $id): ProjectLike;

    public function delete(int $userId, int $projectId): bool;

    public function countByProject(int $projectId): int;
}
