<?php

namespace App\Repositories\V1\Projects;

use App\Models\ProjectLike;

class ProjectLikeRepository implements ProjectLikeRepositoryInterface
{
    public function findByUserAndProject(int $userId, int $projectId): bool
    {
        return ProjectLike::query()->where('user_id', $userId)
            ->where('project_id', $projectId)
            ->exists();
    }

    public function create(array $data): ProjectLike
    {
        return ProjectLike::create($data);
    }

    public function delete(int $userId, int $projectId): bool
    {
        return ProjectLike::where('user_id', $userId)
            ->where('project_id', $projectId)->delete();
    }

    public function findById(int $id): ProjectLike
    {
        return ProjectLike::findOrFail($id);
    }

    public function countByProject(int $projectId): int
    {
        return ProjectLike::where('project_id', $projectId)->count();
    }
}
