<?php

namespace App\Repositories\V1\Projects;

use App\Models\ProjectImage;
use Illuminate\Support\Collection;

interface ProjectImageRepositoryInterface
{
    public function create(array $data): Collection;

    public function first(int $id): ?ProjectImage;

    public function delete(int $id): bool;

    public function getCountByProjectId(int $projectId): int;

    public function assignImages(int $projectId, array $imageIds): bool;
}
