<?php

namespace App\Repositories\V1\Projects;

use App\Models\ProjectImage;
use Illuminate\Support\Collection;

class MysqlProjectImageRepository implements ProjectImageRepositoryInterface
{
    public function create(array $data): Collection
    {
        $images = collect();
    
        foreach ($data['images'] as $path) {
            $images->push(
                ProjectImage::create([
                    'image' => $path,
                ])
            );
        }

        return $images;
    }

    public function first(int $id): ?ProjectImage
    {
        return ProjectImage::query()
            ->with('project')
            ->where('id', '=', $id)
            ->first();
    }

    public function delete(int $id): bool
    {
        return ProjectImage::where('id', '=', $id)
            ->delete();
    }

    public function getCountByProjectId(int $projectId): int
    {
        return ProjectImage::query()
            ->where('project_id', '=', $projectId)
            ->count();
    }

    public function assignImages(int $projectId, array $imageIds): bool
    {
        return ProjectImage::whereIn('id', $imageIds)
            ->update(['project_id' => $projectId]);
    }
}
