<?php

namespace App\Repositories\V1\InternalUsers;

use App\Enums\StatusEnum;
use App\Models\InternalUser;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlInternalUserRepository implements InternalUserRepositoryInterface
{
    public function first(array $conditions): ?InternalUser
    {
        return InternalUser::query()->where($conditions)->first();
    }

    public function update(int $userId, array $data): bool
    {
        return InternalUser::where('id', $userId)
            ->where('is_admin','=', StatusEnum::INACTIVE->value)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(InternalUser::query())
            ->where('is_admin','=', StatusEnum::INACTIVE->value)
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): InternalUser
    {
        return InternalUser::query()->create($data);
    }

    public function getById(int $id): InternalUser
    {
        return InternalUser::query()->findOrFail($id);
    }
    
    public function delete(int $id): bool
{
    return InternalUser::where('id', $id)->delete();
}

}
