<?php

namespace App\Repositories\V1\InternalUsers;

use App\Models\InternalUser;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface InternalUserRepositoryInterface
{
    public function first(array $conditions): ?InternalUser;

    public function update(int $userId, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): InternalUser;

    public function getById(int $id): InternalUser;
    
    public function delete(int $id): bool;

}
