<?php

namespace App\Repositories\V1\Footers;

use App\Models\FooterTitleDetail;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlFooterTitleDetailRepository implements FooterTitleDetailRepositoryInterface
{
    public function first(array $conditions): ?FooterTitleDetail
    {
        return FooterTitleDetail::query()->with('title')->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return FooterTitleDetail::where('id', $id)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(FooterTitleDetail::query())
            ->with('title')
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): FooterTitleDetail
    {
        return FooterTitleDetail::query()->create($data);
    }

    public function getById(int $id): FooterTitleDetail
    {
        return FooterTitleDetail::query()->findOrFail($id);
    }
    
    public function indexAll(Utility $utility)
{
    return $utility->applyOnBuilder(FooterTitleDetail::query())
        ->with('title')
        ->orderByDesc('id')
        ->get();
}

}
