<?php

namespace App\Repositories\V1\Footers;

use App\Models\FooterTitleDetail;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface FooterTitleDetailRepositoryInterface
{
    public function first(array $conditions): ?FooterTitleDetail;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): FooterTitleDetail;

    public function getById(int $id): FooterTitleDetail;
    
    public function indexAll(Utility $utility);

}
