<?php

namespace App\Repositories\V1\Countries;

use App\Models\Country;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;



class MysqlCountryRepository implements CountryRepositoryInterface
{
    public function first(array $conditions): ?Country
    {
        return Country::where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return Country::where('id', $id)->update($data);
    }

        public function index(Utility $utility): Collection
        {
            return $utility->applyOnBuilder(Country::query())
                ->orderByDesc('id')
                ->get();
        }
        
        public function indexPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(Country::query())
            ->orderByDesc('id')
            ->paginate($perPage);
    }


    public function create(array $data): Country
    {
        return Country::create($data);
    }

    public function getById(int $id): Country
    {
        return Country::findOrFail($id);
    }
}
