<?php

namespace App\Repositories\V1\Countries;

use App\Models\Country;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;

interface CountryRepositoryInterface
{
    public function first(array $conditions): ?Country;

    public function update(int $id, array $data): bool;
    
    public function index(Utility $utility): Collection;
    
    public function indexPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator;
    
    public function create(array $data): Country;
    
    public function getById(int $id): Country;
}
