<?php

namespace App\Repositories\V1\Contacts;

use App\Models\Contact;
use Illuminate\Pagination\LengthAwarePaginator;

class MysqlContactRepository implements ContactRepositoryInterface
{
    public function create(array $data): Contact
    {
        return Contact::query()->create($data);
    }

    public function index(int $limit): LengthAwarePaginator
    {
        return Contact::query()
            ->orderByDesc('id')
            ->paginate($limit);
    }

    public function getById(int $id): Contact
    {
        return Contact::query()->findOrFail($id);
    }

    public function update(int $id, array $data): bool
    {
        return Contact::query()
            ->where('id', $id)
            ->update($data);
    }

    public function delete(int $id): void
    {
        Contact::query()
            ->where('id', $id)
            ->delete();
    }
}
