<?php

namespace App\Repositories\V1\Cities;

use App\Models\City;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Database\Eloquent\Collection;

interface CityRepositoryInterface
{
    public function first(array $conditions): ?City;

    public function update(int $id, array $data): bool;
    

    public function indexPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator;


    public function index(Utility $utility): Collection;

    public function create(array $data): City;

    public function getById(int $id): City;
}
