<?php

namespace App\Repositories\V1\Categories;

use App\Models\Category;
use App\Models\CategoryProfessional;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface CategoryRepositoryInterface
{
    public function first(array $conditions): ?Category;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): Category;

    public function getById(int $id): Category;

    public function getCategoryProfessionalsByCategoryId(int $id): Collection;

    public function updateCategoryProfessionals(int $id, array $data): bool;

    public function createCategoryProfessionals(array $data): CategoryProfessional;
}
