<?php

namespace App\Repositories\V1\Blogs;

use App\Models\BlogImage;
use Illuminate\Support\Collection;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;


class MysqlBlogImageRepository implements BlogImageRepositoryInterface
{
    public function create(int $blogId, array $images): Collection
{
    $collection = collect();

    foreach ($images as $image) {

        $path = $image->store('blogs', 'public');

        $collection->push(
            BlogImage::create([
                'blog_id' => $blogId,
                'image'   => $path,
            ])
        );
    }

    return $collection;
}

    public function first(int $id): ?BlogImage
    {
        return BlogImage::query()
            ->with('blog')
            ->where('id', '=', $id)
            ->first();
    }

    public function delete(int $id): bool
    {
        return BlogImage::where('id', '=', $id)
            ->delete();
    }

    public function getCountByBlogId(int $blogId): int
    {
        return BlogImage::query()
            ->where('blog_id', '=', $blogId)
            ->count();
    }

    public function assignImages(int $blogId, array $imageIds): bool
    {
        return BlogImage::whereIn('id', $imageIds)
            ->update(['blog_id' => $blogId]);
    }

    public function deleteByIds(int $blogId, array $imageIds): void
    {
        BlogImage::where('blog_id', $blogId)
            ->whereIn('id', $imageIds)
            ->delete();
    }
}
