<?php

namespace App\Repositories\V1\Blogs;

use App\Models\Blog;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface BlogRepositoryInterface
{
    public function index(int $limit): LengthAwarePaginator;

    public function getById(int $id): Blog;

    public function create(array $data): Blog;

    public function update(int $id, array $data): bool;

    public function delete(int $id): bool;
}

