<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Country extends Model
{
    protected $fillable = ['name_en', 'name_ar', 'status'];

    public function states(): HasMany
    {
        return $this->hasMany(State::class);
    }

    public function getNameAttribute(): string
    {
        return $this->{'name_' . app()->getLocale()};
    }
}