<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class City extends Model
{
    protected $fillable = ['id', 'name_en', 'name_ar', 'status', 'state_id'];

    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function getNameAttribute(): string
    {
        return $this->{'name_' . app()->getLocale()};
    }
}
