<?php

namespace App\Models;

use App\Enums\UserTypeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Category extends Model
{
    protected $fillable = ['id', 'name_en', 'name_ar', 'description_en', 'description_ar', 'status', 'type', 'image', 'home_status', 'sort', 'footer_visibility'];

    // public function getImageAttribute(?string $image = null): ?string
    // {
    //     return $image ? s3_images_url($image) : null;
    // }

    public function getimageAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url($image) : null;
    }

    // public function setImageAttribute($value): void
    // {
    //     $this->attributes['image'] = upload_s3_images($value, 'categories/images');
    // }

    public function setimageAttribute($value): void
    {
        $this->attributes['image'] = upload_s3_images($value, 'categories/images');
    }

    public function getNameAttribute(): string
    {
        return $this->{'name_' . app()->getLocale()};
    }

    public function professionals(): BelongsToMany
    {
        return $this->belongsToMany(
            User::class,
            CategoryProfessional::class,
            'category_id',
            'user_id'
        )->where('type', UserTypeEnum::PROFESSIONAL->value);
    }
}
