<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BlogImage extends Model
{
    protected $guarded = [];

    public function blog(): BelongsTo
    {
        return $this->belongsTo(Blog::class);
    }

    public function getImageAttribute($image): string
    {
        return asset('storage/' . $image);
    }
}

