<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Blog extends Model
{
    protected $fillable = [
        'name_en',
        'name_ar',
        'title_en',
        'title_ar',
        'description_en',
        'description_ar',
        'meta_title_en',
        'meta_title_ar',
        'meta_description_en',
        'meta_description_ar',
        'alt_image_en',
        'alt_image_ar',
    ];

    protected $with = ['firstImage'];

    public function firstImage(): HasOne
    {
        return $this->hasOne(BlogImage::class);
    }

    public function images(): HasMany
    {
        return $this->hasMany(BlogImage::class);
    }
}
