<?php

namespace App\Http\Resources\V1\Projects;

use App\Http\Resources\V1\CategoryResource;
use App\Http\Resources\V1\LookupResource;
use App\Enums\Project\OfferType;
use App\Enums\Project\Condition;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $authUser = $request->user();
        
        return [
            'id' => $this->id,
            'name_en' => $this->name_en,
            'name_ar' => $this->name_ar,
            'name' => $this->name, // الاسم حسب اللغة
            'description_en' => $this->description_en,
            'description_ar' => $this->description_ar,
            'description' => $this->description, // الوصف حسب اللغة
            'area_en' => $this->area_en,
            'area_ar' => $this->area_ar,
            'area' => $this->area, // المنطقة حسب اللغة
            'number_of_bathrooms' => $this->number_of_bathrooms,
            'number_of_rooms' => $this->number_of_rooms,
            'number_of_beds' => $this->number_of_beds,
            'price' => $this->price,
            'price_formatted' => $this->price_formatted,
            'price_currency' => $this->price_currency,
            
            'total_area' => $this->total_area,
            'land_area' => $this->land_area,
            'built_area' => $this->built_area,
            
            'total_floors' => $this->total_floors,
            'total_units' => $this->total_units,
            
            'handover_date' => $this->handover_date_formatted,
            'offer_type' => [
                'value' => $this->offer_type?->value,
                'label' => $this->offer_type_text,
            ],
            'condition' => [
                'value' => $this->condition?->value,
                'label' => $this->condition_text,
            ],
            
            'facilities' => $this->facilities,
            'sort'=>$this->sort,
            'down_payment' => $this->down_payment,
            'installments_count' => $this->installments_count,
            'installment_amount' => $this->installment_amount,
            'has_pool' => $this->boolToInt($this->has_pool),
            'has_gym' => $this->boolToInt($this->has_gym),
            'has_parking' => $this->boolToInt($this->has_parking),
            'furnished' => $this->boolToInt($this->furnished),

            'tiktok_link' => $this->tiktok_link,
            
            // العلاقات
            'relations' => [
                'user' => [
                    'image' => $this->user->details?->image,
                    'name_en' => $this->user?->name_en,
                    'name_ar' => $this->user?->name_ar,
                ],
                'images' => ProjectImageResource::collection($this->images),
                'likesCount' => $this->getLikesCountAttribute(),
                'isLiked' => $authUser ? $this->isLikedBy($authUser->id) : false,
                'category' => CategoryResource::make($this->category),
                'subCategory' => $this->subCategory ? [
                    'id' => $this->subCategory->id,
                    'name_en' => $this->subCategory->name_en,
                    'name_ar' => $this->subCategory->name_ar,
                ] : null,
                'country' => LookupResource::make($this->state?->country),
                'state' => LookupResource::make($this->state),
                'city' => LookupResource::make($this->city),
                // 'designType' => LookupResource::make($this->designType),
                // 'projectType' => LookupResource::make($this->projectType),
                // 'budget' => LookupResource::make($this->budget),
            ]
        ];
    }

    private function isLikedByUser($user)
    {
        return $user && $this->projectLikes()->where('user_id', $user->id)->exists() ? 1 : 0;
    }
    
         private function boolToInt($value): int
    {
        return (floatval($value) === 1.00) ? 1 : 0;
    }

}
