<?php

namespace App\Http\Resources\V1\Projects;

use Illuminate\Http\Resources\Json\JsonResource;

class ProjectCommentResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'comment' => $this->comment,
            'created_at' => $this->created_at,
            'relations' => [
                'user' => [
                    'id' => $this->user->id,
                    'name' => $this->user->name,
                    'image' => $this->user->userDetail?->image,
                ],
                'replies' => ProjectCommentResource::collection($this->whenLoaded('replies')),
            ],
        ];
    }
}