<?php

namespace App\Http\Resources\V1;

use App\Enums\StatusEnum;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InternalUserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'status' => StatusEnum::getNameFromValue($this->status),
            'phone_number'=> $this->phone_number,
            'relations' => [
                'roles' => LookupResource::collection($this->roles),
                'permissions' => PermissionResource::collection($this->getAllPermissions()),
            ]
        ];
    }
}
