<?php

namespace App\Http\Requests\V1\Tags;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class StoreTagRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-tags');
    }

    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string'],
            'name_ar' => ['required', 'string'],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
            'icon' => ['required', 'image', 'mimes:jpg,png,jpeg', 'max:2048'],
        ];
    }
}
