<?php

namespace App\Http\Requests\V1\States;

use App\Enums\CategoryTypeEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Enum;

class StoreStateRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-states');
    }

    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string'],
            'name_ar' => ['required', 'string'],
            'country_id' => ['required', 'integer', Rule::exists('countries', 'id')],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}
