<?php

namespace App\Http\Requests\V1\Sliders;

use App\Enums\SliderPageEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class UpdateSliderRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-tags');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'boolean'],
            'page' => ['required', new Enum(SliderPageEnum::class)],
            'image_en' => ['sometimes', 'image', 'mimes:jpg,png,jpeg'],
            'image_ar' => ['sometimes', 'image', 'mimes:jpg,png,jpeg'],
            'title_en' => ['sometimes', 'string', 'max:255'],
            'title_ar' => ['sometimes', 'string', 'max:255'],
        ];
    }
}
