<?php

namespace App\Http\Requests\V1\Sliders;

use App\Enums\SliderPageEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class StoreSliderRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-sliders');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'boolean'],
            'page' => ['required', new Enum(SliderPageEnum::class)],
            'image_en' => ['required', 'image', 'mimes:jpg,png,jpeg'],
            'image_ar' => ['required', 'image', 'mimes:jpg,png,jpeg'],
            'title_en' => ['required', 'string', 'max:255'],
            'title_ar' => ['required', 'string', 'max:255'],
        ];
    }
}
