<?php

namespace App\Http\Requests\V1;

use Illuminate\Foundation\Http\FormRequest;

class ServiceRequest extends FormRequest
{
    public function authorize()
    {
        return true; // السماح لجميع المستخدمين
    }

    public function rules()
    {
        return [
            'name_en' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'description' => 'nullable|string',
            'category_id' => 'required|exists:categories,id',
            'status' => 'nullable|in:0,1',
            'home_status' => 'nullable|in:0,1',
            'sort' => 'nullable|integer',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            // 'icon' => 'nullable|string|max:255',
        ];
    }

    public function messages()
    {
        return [
            'name_en.required' => 'The English name is required.',
            'name_ar.required' => 'The Arabic name is required.',
            'category_id.required' => 'The category ID is required.',
            'category_id.exists' => 'The selected category does not exist.',
        ];
    }
}
