<?php

namespace App\Http\Requests\V1\Roles;

use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;

class UpdateRoleRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-roles');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', Rule::unique('roles', 'name')->ignore($this->id)],
            'permission_ids' => ['required', 'array', 'min:1'],
            'permission_ids.*' => ['integer'],
        ];
    }
}
