<?php

namespace App\Http\Requests\V1\Projects;

use App\Http\Requests\BaseFormRequest;
use Illuminate\Validation\Rule;

class StoreProjectCommentRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'comment' => ['required', 'string', 'max:1000'],
            'parent_id' => ['nullable', 'integer', Rule::exists('project_comments', 'id')->whereNull('parent_id'),
            ],
        ];
    }
}
