<?php

namespace App\Http\Requests\V1\FooterTitleDetails;

use App\Enums\FooterRedirectToEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Enum;

class UpdateFooterTitleDetailRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-budgets');
    }

    public function rules(): array
    {
        return [
            'title_en' => ['required', 'string'],
            'title_ar' => ['required', 'string'],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
            'redirect_to' => ['required', 'integer', new Enum(FooterRedirectToEnum::class)],
            'link' => ['required', 'string'],
            'footer_title_id' => ['required', 'integer', Rule::exists('footer_titles', 'id')],
        ];
    }
}
