<?php

namespace App\Http\Requests\V1\Categories;

use App\Enums\CategoryTypeEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class UpdateCategoryRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-categories');
    }

    public function rules(): array
    {
        return [
            'name_en' => ['sometimes', 'string'],
            'name_ar' => ['sometimes', 'string'],
            'description_en' => ['sometimes', 'string'],
            'description_ar' => ['sometimes', 'string'],
            'status' => ['sometimes', 'boolean', new Enum(StatusEnum::class)],
            'home_status' => ['sometimes', 'boolean', new Enum(StatusEnum::class)],
            'footer_visibility' => ['nullable', 'boolean', new Enum(StatusEnum::class)],
            'image' => ['sometimes', 'image', 'mimes:jpg,png,jpeg'],
        ];
    }
}
