<?php

namespace App\Http\Requests\V1\Categories;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class ChangeStatusCategoryRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-categories');
    }

    public function rules(): array
    {
        return [
            'status' => ['sometimes', 'boolean', new Enum(StatusEnum::class)],
            'home_status' => ['sometimes', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}
