<?php

namespace App\Http\Requests\V1\Auth;

use App\Http\Requests\BaseFormRequest;

class LoginRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'email' => ['nullable', 'email'],
            'password' => ['required', 'string'],
            'phone_number' => [
                'required',
                'string',
                'regex:/^(?:\+9665|9665|05|5)\d{8}$/'
            ]
        ];
    }

    public function messages(): array
    {
        return [
            'phone_number.regex' => 'رقم الجوال يجب أن يكون رقم سعودي صالح.'
        ];
    }
}
