<?php

namespace App\Http\Requests\V1\Auth;

use App\Http\Requests\BaseFormRequest;

class ChangeCurrentPasswordRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'old_password' => ['required', 'string'],
            'password' => [
                'required',
                'string',
                'confirmed',
                'different:old_password',
                'min:8',
                'regex:/^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[@$!%*?&#])[A-Za-z\d@$!%*?&#]{8,}$/'
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'password.regex' =>
                'كلمة المرور يجب أن تحتوي على حرف كبير، حرف صغير، رقم، رمز خاص، ولا تقل عن 8 أحرف.',
            'password.different' =>
                'كلمة المرور الجديدة يجب أن تكون مختلفة عن كلمة المرور الحالية.',
        ];
    }
}
