<?php

namespace App\Http\Requests;

use App\Enums\GeneralSettingEnum;

class ListingRequest extends BaseFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'limit' => ['sometimes', 'integer', 'min:1'],
        ];
    }

    public function getLimit(): int
    {
        return $this->limit ?? GeneralSettingEnum::PAGINATION_LIMIT->value;
    }
}
