<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Users\ChangeUserStatusAction;
use App\Actions\V1\Users\GetUserAction;
use App\Actions\V1\Users\UserListAction;
use App\Dto\V1\UserDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Users\ChangeStatusUserRequest;
use App\Http\Resources\V1\UserResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Users\UsersUtility;

class UserController
{
    public function index(ListingRequest $request, UserListAction $action, UsersUtility $utility): JsonResponse
    {
        Gate::authorize('view-users');
        return api_response(data: UserResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getById(int $id, GetUserAction $action): JsonResponse
    {
        Gate::authorize('view-users');
        return api_response(data: UserResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusUserRequest $request, ChangeUserStatusAction $action): JsonResponse
    {
        $action->execute(new UserDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
}
