<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Tags\ChangeTagStatusAction;
use App\Actions\V1\Tags\GetTagAction;
use App\Actions\V1\Tags\TagListAction;
use App\Actions\V1\Tags\StoreTagAction;
use App\Actions\V1\Tags\UpdateTagAction;
use App\Dto\V1\TagDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Tags\ChangeStatusTagRequest;
use App\Http\Requests\V1\Tags\StoreTagRequest;
use App\Http\Requests\V1\Tags\UpdateTagRequest;
use App\Http\Resources\V1\TagResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Tags\TagsUtility;

class TagController
{
    public function index(ListingRequest $request, TagListAction $action, TagsUtility $utility): JsonResponse
    {
        Gate::authorize('view-tags');
        return api_response(data: TagResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getById(int $id, GetTagAction $action): JsonResponse
    {
        Gate::authorize('view-tags');
        return api_response(data: TagResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreTagRequest $request, StoreTagAction $action): JsonResponse
    {
        return api_response(data: TagResource::make($action->execute(new TagDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateTagRequest $request, UpdateTagAction $action): JsonResponse
    {
        $action->execute(new TagDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusTagRequest $request, ChangeTagStatusAction $action): JsonResponse
    {
        $action->execute(new TagDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
}
