<?php

namespace App\Http\Controllers\V1;

use Illuminate\Http\JsonResponse;
use App\Dto\V1\SubCategoryDto;
use App\Http\Requests\ListingRequest;
use App\Http\Resources\V1\SubCategoryResource;
use App\Actions\V1\SubCategories\{
    SubCategoryListAction,
    GetSubCategoryAction,
    StoreSubCategoryAction,
    UpdateSubCategoryAction,
    DeleteSubCategoryAction
};

use App\Http\Requests\V1\SubCategories\{
    StoreSubCategoryRequest,
    UpdateSubCategoryRequest
};
use Infrastructure\Services\Utilities\SubCategories\SubCategoriesUtility;
use App\Models\SubCategory;


class SubCategoryController
{
    public function index(
        ListingRequest $request,
        SubCategoryListAction $action,
        SubCategoriesUtility $utility
    ): JsonResponse {
        return api_response(
            data: SubCategoryResource::collection(
                $action->execute($utility, $request->getLimit())
            ),
            message: __('general.success_request')
        );
    }
    
    
    public function all()
{

    $categories = SubCategory::all();

    return api_response(
        data: SubCategoryResource::collection($categories),
        message: __('general.success_request')
    );
    
}


    public function getById(
        int $id,
        GetSubCategoryAction $action
    ): JsonResponse {
        return api_response(
            data: SubCategoryResource::make($action->execute($id)),
            message: __('general.success_request')
        );
    }
    public function indexnotauth(
        ListingRequest $request,
        SubCategoryListAction $action,
        SubCategoriesUtility $utility
    ): JsonResponse {
        return api_response(
            data: SubCategoryResource::collection(
                $action->execute($utility, $request->getLimit())
            ),
            message: __('general.success_request')
        );
    }

    public function getByIdnotauth(
        int $id,
        GetSubCategoryAction $action
    ): JsonResponse {
        return api_response(
            data: SubCategoryResource::make($action->execute($id)),
            message: __('general.success_request')
        );
    }
    public function store(
        StoreSubCategoryRequest $request,
        StoreSubCategoryAction $action
    ): JsonResponse {
        return api_response(
            data: SubCategoryResource::make(
                $action->execute(
                    new SubCategoryDto(...$request->validatedInCamelCase())
                )
            ),
            message: __('general.success_request')
        );
    }


    public function update(
        int $id,
        UpdateSubCategoryRequest $request,
        UpdateSubCategoryAction $action
    ): JsonResponse {
        return api_response(
            data: SubCategoryResource::make(
                $action->execute(
                    new SubCategoryDto(...$request->validatedInCamelCase()),
                    $id
                )
            ),
            message: __('general.success_request')
        );
    }

    public function delete(
        int $id,
        DeleteSubCategoryAction $action
    ): JsonResponse {
        $action->execute($id);

        return api_response(
            message: __('general.success_request')
        );
    }
}
