<?php

namespace App\Http\Controllers\V1;

use App\Exceptions\ProjectLikeException;
use App\Actions\V1\Project\{GetProjectLikesCountAction, ToggleProjectLikeAction};
use App\Dto\V1\Project\ProjectLikeDto;
use Illuminate\Http\JsonResponse;

class LikeController
{
    /**
     * @throws ProjectLikeException
     */
    public function toggleLike(int $id, ToggleProjectLikeAction $action): JsonResponse
    {
        return api_response(data: ['likes' => $action->execute(new ProjectLikeDto($id, auth()->id()))],
            message: __('general.success_request')
        );
    }

    public function likesCount(int $id, GetProjectLikesCountAction $action): JsonResponse
    {
        return api_response(data: ['likes_count' => $action->execute($id)],
            message: __('general.success_request'),
        );
    }
}
