<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Labels\ChangeLabelStatusAction;
use App\Actions\V1\Labels\GetLabelAction;
use App\Actions\V1\Labels\LabelListAction;
use App\Actions\V1\Labels\StoreLabelAction;
use App\Actions\V1\Labels\UpdateLabelAction;
use App\Dto\V1\LabelDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Labels\ChangeStatusLabelRequest;
use App\Http\Requests\V1\Labels\StoreLabelRequest;
use App\Http\Requests\V1\Labels\UpdateLabelRequest;
use App\Http\Resources\V1\LabelResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Labels\LabelsUtility;

class LabelController
{
    public function index(ListingRequest $request, LabelListAction $action, LabelsUtility $utility): JsonResponse
    {
        Gate::authorize('view-pricing-units');
        return api_response(data: LabelResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getById(int $id, GetLabelAction $action): JsonResponse
    {
        Gate::authorize('view-pricing-units');
        return api_response(data: LabelResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreLabelRequest $request, StoreLabelAction $action): JsonResponse
    {
        return api_response(data: LabelResource::make($action->execute(new LabelDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateLabelRequest $request, UpdateLabelAction $action): JsonResponse
    {
        $action->execute(new LabelDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusLabelRequest $request, ChangeLabelStatusAction $action): JsonResponse
    {
        $action->execute(new LabelDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
}
