<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\InternalUsers\ChangeInternalUserStatusAction;
use App\Actions\V1\InternalUsers\GetInternalUserAction;
use App\Actions\V1\InternalUsers\InternalUserListAction;
use App\Actions\V1\InternalUsers\StoreInternalUserAction;
use App\Actions\V1\InternalUsers\UpdateInternalUserAction;
use App\Dto\V1\InternalUserDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\InternalUsers\ChangeStatusInternalUserRequest;
use App\Http\Requests\V1\InternalUsers\StoreInternalUserRequest;
use App\Http\Requests\V1\InternalUsers\UpdateInternalUserRequest;
use App\Http\Resources\V1\InternalUserResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\InternalUsers\InternalUsersUtility;
use App\Actions\V1\InternalUsers\DeleteInternalUserAction;

class InternalUserController
{
    public function index(ListingRequest $request, InternalUserListAction $action, InternalUsersUtility $utility): JsonResponse
    {
        Gate::authorize('view-internal-users');
        return api_response(data: InternalUserResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getById(int $id, GetInternalUserAction $action): JsonResponse
    {
        Gate::authorize('view-internal-users');
        return api_response(data: InternalUserResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreInternalUserRequest $request, StoreInternalUserAction $action): JsonResponse
    {
        return api_response(data: InternalUserResource::make($action->execute(new InternalUserDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateInternalUserRequest $request, UpdateInternalUserAction $action): JsonResponse
    {
        return api_response(data: InternalUserResource::make($action->execute(new InternalUserDto(...$request->validatedInCamelCase()), $id)),
            message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusInternalUserRequest $request, ChangeInternalUserStatusAction $action): JsonResponse
    {
        $action->execute(new InternalUserDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    public function delete(int $id, DeleteInternalUserAction $action): JsonResponse
    {
        Gate::authorize('delete-internal-users');

        $action->execute($id);

        return api_response(message: __('general.success_request'));
    }
}
