<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\FooterTitleDetails\FooterTitleDetailListAction;
use App\Actions\V1\FooterTitleDetails\ChangeFooterTitleDetailStatusAction;
use App\Actions\V1\FooterTitleDetails\GetFooterTitleDetailAction;
use App\Actions\V1\FooterTitleDetails\StoreFooterTitleDetailAction;
use App\Actions\V1\FooterTitleDetails\UpdateFooterTitleDetailAction;
use App\Dto\V1\FooterTitleDetailDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\FooterTitleDetails\ChangeStatusFooterTitleDetailRequest;
use App\Http\Requests\V1\FooterTitleDetails\StoreFooterTitleDetailRequest;
use App\Http\Requests\V1\FooterTitleDetails\UpdateFooterTitleDetailRequest;
use App\Http\Resources\V1\FooterTitleDetailResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Footers\FooterTitleDetailsUtility;
use Infrastructure\Services\Utilities\Footers\FooterTitlesUtility;
use App\Models\FooterTitleDetail;


class FooterTitleDetailController
{
    public function index(ListingRequest $request, FooterTitleDetailListAction $action, FooterTitleDetailsUtility $utility): JsonResponse
    {
        Gate::authorize('view-footers');
        return api_response(data: FooterTitleDetailResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
public function indexnotpaginated(FooterTitleDetailListAction $action, FooterTitlesUtility $utility): JsonResponse
{
    return api_response(
        data: FooterTitleDetailResource::collection($action->executeAll($utility)),
        message: __('general.success_request')
    );
}


    public function getById(int $id, GetFooterTitleDetailAction $action): JsonResponse
    {
        Gate::authorize('view-footers');
        return api_response(data: FooterTitleDetailResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
    
    public function indexnotauth(ListingRequest $request, FooterTitleDetailListAction $action, FooterTitleDetailsUtility $utility): JsonResponse
    {
        return api_response(data: FooterTitleDetailResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getByIdnotauth(int $id, GetFooterTitleDetailAction $action): JsonResponse
    {
        return api_response(data: FooterTitleDetailResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreFooterTitleDetailRequest $request, StoreFooterTitleDetailAction $action): JsonResponse
    {
        return api_response(data: FooterTitleDetailResource::make($action->execute(new FooterTitleDetailDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateFooterTitleDetailRequest $request, UpdateFooterTitleDetailAction $action): JsonResponse
    {
        $action->execute(new FooterTitleDetailDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusFooterTitleDetailRequest $request, ChangeFooterTitleDetailStatusAction $action): JsonResponse
    {
        $action->execute(new FooterTitleDetailDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
        public function destroy(int $id): JsonResponse
    {
         Gate::authorize('delete-footers'); // authorization
    
        $footerDetail = FooterTitleDetail::findOrFail($id);
        $footerDetail->delete(); // حذف عادي
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
