<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Contacts\ContactListAction;
use App\Actions\V1\Contacts\DeleteContactAction;
use App\Actions\V1\Contacts\GetContactAction;
use App\Actions\V1\Contacts\StoreContactAction;
use App\Actions\V1\Contacts\UpdateContactAction;
use App\Dto\V1\ContactDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Contacts\StoreContactRequest;
use App\Http\Requests\V1\Contacts\UpdateContactRequest;
use App\Http\Resources\V1\ContactResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;

class ContactController
{
    public function index(ListingRequest $request, ContactListAction $action): JsonResponse
    {
        Gate::authorize('view-contacts');
        $contacts = $action->execute($request->getLimit());

        return api_response(
            data: ContactResource::collection($contacts),
            message: __('general.success_request')
        );
    }

    public function show(int $id, GetContactAction $action): JsonResponse
    {
        return api_response(
            data: ContactResource::make($action->execute($id)),
            message: __('general.success_request')
        );
    }

    public function store(StoreContactRequest $request, StoreContactAction $action): JsonResponse
    {
        $contact = $action->execute(new ContactDto(...$request->validatedInCamelCase()));

        return api_response(
            data: ContactResource::make($contact),
            message: 'Contact created successfully'
        );
    }

    public function update(int $id, UpdateContactRequest $request, UpdateContactAction $action): JsonResponse
    {
        $contact = $action->execute(new ContactDto(...$request->validatedInCamelCase()), $id);

        return api_response(
            data: ContactResource::make($contact),
            message: __('general.success_request')
        );
    }

    public function destroy(int $id, DeleteContactAction $action): JsonResponse
    {
         Gate::authorize('delete-contacts');

        $action->execute($id);

        return api_response(
            message: __('general.success_request')
        );
    }
}
