<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Cities\ChangeCityStatusAction;
use App\Actions\V1\Cities\CityListAction;
use App\Actions\V1\Cities\GetCityAction;
use App\Actions\V1\Cities\StoreCityAction;
use App\Actions\V1\Cities\UpdateCityAction;
use App\Dto\V1\CityDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Cities\ChangeStatusCityRequest;
use App\Http\Requests\V1\Cities\StoreCityRequest;
use App\Http\Requests\V1\Cities\UpdateCityRequest;
use App\Http\Resources\V1\CityResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Cities\CitiesUtility;
use App\Models\City;

class CityController
{
    public function index(ListingRequest $request, CityListAction $action, CitiesUtility $utility): JsonResponse
    {
        Gate::authorize('view-cities');
        return api_response(data: CityResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
public function indexpaginated(ListingRequest $request, CityListAction $action, CitiesUtility $utility): JsonResponse
{
    Gate::authorize('view-cities');

    return api_response(
        data: CityResource::collection(
            $action->executeWithPagination($utility, $request->getLimit())
        ),
        message: __('general.success_request')
    );
}



    public function getById(int $id, GetCityAction $action): JsonResponse
    {
        return api_response(data: CityResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
        public function indexnotauth(ListingRequest $request, CityListAction $action, CitiesUtility $utility): JsonResponse
    {
        return api_response(data: CityResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getByIdnotauth(int $id, GetCityAction $action): JsonResponse
    {
        Gate::authorize('view-cities');
        return api_response(data: CityResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreCityRequest $request, StoreCityAction $action): JsonResponse
    {
        return api_response(data: CityResource::make($action->execute(new CityDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateCityRequest $request, UpdateCityAction $action): JsonResponse
    {
        $action->execute(new CityDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusCityRequest $request, ChangeCityStatusAction $action): JsonResponse
    {
        $action->execute(new CityDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
        public function destroy(int $id): JsonResponse
    {
        Gate::authorize('delete-cities');
    
        $city = City::findOrFail($id);
        $city->delete();
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
