<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Categories\CategoryListAction;
use App\Actions\V1\Categories\ChangeCategoryStatusAction;
use App\Actions\V1\Categories\GetCategoryAction;
use App\Actions\V1\Categories\StoreCategoryAction;
use App\Actions\V1\Categories\UpdateCategoryAction;
use App\Dto\V1\CategoryDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Categories\ChangeStatusCategoryRequest;
use App\Http\Requests\V1\Categories\StoreCategoryRequest;
use App\Http\Requests\V1\Categories\UpdateCategoryRequest;
use App\Http\Resources\V1\CategoryResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Categories\CategoriesUtility;
use App\Models\Category;


class CategoryController
{
    public function index(ListingRequest $request, CategoryListAction $action, CategoriesUtility $utility): JsonResponse
    {
        Gate::authorize('view-categories');
        return api_response(data: CategoryResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
    public function all()
{

    $categories = Category::all();

    return api_response(
        data: CategoryResource::collection($categories),
        message: __('general.success_request')
    );
    
}

    public function getById(int $id, GetCategoryAction $action): JsonResponse
    {
        Gate::authorize('view-categories');
        return api_response(data: CategoryResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
    
   public function indexnotauth(ListingRequest $request, CategoryListAction $action, CategoriesUtility $utility): JsonResponse
    {
        return api_response(data: CategoryResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getByIdnotauth(int $id, GetCategoryAction $action): JsonResponse
    {
        return api_response(data: CategoryResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreCategoryRequest $request, StoreCategoryAction $action): JsonResponse
    {
        return api_response(data: CategoryResource::make($action->execute(new CategoryDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateCategoryRequest $request, UpdateCategoryAction $action): JsonResponse
    {
        $action->execute(new CategoryDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusCategoryRequest $request, ChangeCategoryStatusAction $action): JsonResponse
    {
        $action->execute(new CategoryDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
    
    public function destroy(int $id): JsonResponse
    {
         Gate::authorize('delete-categories'); // authorization
    
        $category = Category::findOrFail($id);
        $category->delete();  
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
