<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Auth\ChangeCurrentPasswordAction;
use App\Actions\V1\Auth\LoginAction;
use App\Dto\V1\Auth\AuthDto;
use App\Dto\V1\Auth\UserDto;
use App\Http\Requests\V1\Auth\ChangeCurrentPasswordRequest;
use App\Http\Requests\V1\Auth\LoginRequest;
use App\Http\Resources\V1\InternalUserResource;
use Illuminate\Http\JsonResponse;

class AuthController
{
    public function login(LoginRequest $request, LoginAction $loginAction): JsonResponse
    {
        $result = $loginAction->execute(new AuthDto(...$request->validatedInCamelCase()));
        return api_response(data: $result, message: __('general.success_request'));
    }

    public function changeCurrentPassword(ChangeCurrentPasswordRequest $request, ChangeCurrentPasswordAction $action): JsonResponse
    {
        $action->execute(new UserDto(...$request->validatedInCamelCase()), auth()->id());
        return api_response(message: __('general.success_request'));
    }

    public function logout(): JsonResponse
    {
        auth()->user()->currentAccessToken()->delete();
        return api_response(message: __('general.success_request'));
    }


    public function getUserData(): JsonResponse
    {
        return api_response(data: [
            'user' => InternalUserResource::make(auth()->user()),
        ], message: __('general.success_request'));
    }
}
