<?php

use Illuminate\Support\Facades\Storage;
use Intervention\Image\Drivers\Gd\Driver;
use Intervention\Image\ImageManager;
use Spatie\ImageOptimizer\OptimizerChainFactory;

/*
|--------------------------------------------------------------------------
| Get Image URL (Local Instead of S3)
|--------------------------------------------------------------------------
*/

if (!function_exists('s3_images_url')) {
    function s3_images_url($url)
    {
        return asset('storage/uploads/' . $url);
    }
}

/*
|--------------------------------------------------------------------------
| Upload Image (Local Instead of S3)
|--------------------------------------------------------------------------
*/

if (!function_exists('upload_s3_images')) {
    function upload_s3_images($file, $mainFolder = 'images', $customName = null, $store = 'local'): string
    {
        $optimizerChain = OptimizerChainFactory::create();
        $optimizerChain->optimize($file);

        $name = str_replace(
            ' ',
            '',
            $customName ??
            pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME)
            . '-' . time() . '.' . $file->getClientOriginalExtension()
        );

        // Store on local server (public/storage)
        $file->storeAs(
            'uploads/' . $mainFolder,
            $name,
            'public'
        );

        return $mainFolder . '/' . $name;
    }
}

/*
|--------------------------------------------------------------------------
| Copy File (Dummy Function For Compatibility)
|--------------------------------------------------------------------------
*/

if (!function_exists('copy_file_to_s3')) {
    function copy_file_to_s3($path): bool
    {
        // Already local → no copy needed
        return true;
    }
}

/*
|--------------------------------------------------------------------------
| Delete Image (Local Instead of S3)
|--------------------------------------------------------------------------
*/

if (!function_exists('delete_s3_image')) {
    function delete_s3_image($file, $mainFolder = 'images'): bool
    {
        return Storage::disk('public')
            ->delete('uploads/' . $mainFolder . '/' . $file);
    }
}

/*
|--------------------------------------------------------------------------
| Array Helper
|--------------------------------------------------------------------------
*/

if (!function_exists('isArrayAssociative')) {
    function isArrayAssociative(array $array): bool
    {
        $keys = array_keys($array);
        return array_keys($keys) !== $keys;
    }
}

/*
|--------------------------------------------------------------------------
| Create Thumbnail (Local Instead of S3)
|--------------------------------------------------------------------------
*/

if (!function_exists('create_thumbnail')) {
    function create_thumbnail($filePath, $height, $width, $mainPath, $fileName): bool
    {
        $imageManager = new ImageManager(new Driver());

        $image = $imageManager
            ->read(Storage::disk('public')->path($filePath))
            ->resize($width, $height);

        $image->save(
            Storage::disk('public')->path($mainPath . '/' . $fileName)
        );

        return true;
    }
}
