<?php

namespace App\Exceptions\Handlers;

use App\Enums\ActionCodeEnum;
use App\Enums\HTTPStatusCodeEnum;
use Illuminate\Http\Request;
use Throwable;

class BlockedUserExceptionHandler extends BaseExceptionHandler
{
    /**
     * @inheritDoc
     */
    public static function getResponseStatusCode(Throwable $exception): int
    {
        return HTTPStatusCodeEnum::UNAUTHORIZED->value;
    }


    public static function getPayload(Request $request, Throwable $exception): array
    {
        $payload = parent::getPayload($request, $exception);
        $payload['errors']['message'] = $exception->getMessage();
        $payload['errors']['actionCode'] = ActionCodeEnum::BLOCKED_USER->value;
        return $payload;
    }
}
